import Foundation
import OtrnLibrary

func writeOTRNExample() {
    print("--- OTRN Write Example Start ---")
    print("Writing file at: \(filePath)\n")

    // --- 1. Nested Structures (Reply and Tag) ---
    let reply = OtrnReply(
        comment: "This is a follow-up reply about the stabilization.",
        commenter: "Jane Doe",
        timestamp: "2025-11-19T10:05:00Z",
        replyId: UUID()
    )
    
    let tag = OtrnTag(
        name: "Urgent",
        tagId: UUID(),
        group: "Priority"
    )

    // --- 2. Sequence Note (Note used in 'sequence' block) ---
    let sequenceNote = OtrnNote(
        time: 15.34,
        comment: "Camera shake detected. Needs stabilization.",
        timecode: "00:00:15:08",
        frame: 368,
        range: true,
        timeOut: 20.00,
        timecodeOut: "00:00:20:00",
        frameOut: 480,
        name: "Stabilization Issue",
        commenter: "John Smith",
        color: "yellow",
        colorHex: "#FFC300",
        category: "Visual FX",
        track: "V1",
        complete: false,
        timestamp: "2025-11-19T10:00:00Z",
        noteId: UUID(),
        replies: [reply],
        tags: [tag]
    )
    
    // --- 3. File Note (Note used in 'files' block) ---
    let fileNote = OtrnNote(
        time: 5.0,
        comment: "Sound cue needs adjusting.",
        timecode: "00:00:05:00",
        name: "Audio Issue",
        commenter: "Jane Doe",
        color: "blue",
        category: "Audio",
        complete: true,
        noteId: UUID()
    )

    // --- 4. Sequence and File Structures ---
    let sequence = OtrnSequence(
        name: "Main Edit V3",
        frameRate: 23.976,
        dropFrame: false,
        startTime: 0,
        startTimecode: "01:00:00:00",
        startFrame: 0,
        notes: [sequenceNote]
    )
    
    let file = OtrnFile(
        fileName: "Shot_A001.mov",
        filePath: "/Volumes/Media/Projects/A/Shot_A001.mov",
        clipName: "A001_vfx_edit",
        name: "Clip Notes",
        frameRate: 24.0,
        dropFrame: false,
        startTime: 0.0,
        startTimecode: "00:00:00:00",
        startFrame: 0,
        notes: [fileNote]
    )

    // --- 5. Metadata ---
    let metadata = OtrnMetadata(
        project: "The Swift OTRN Project",
        fileName: "video.mp4",
        fileUrl: "file:///video.mp4",
        software: "Swift OtrnLibrary Example",
        otrnVersion: 1,
        otrnInfo: "This is an OTRN (Open Timecode-Related Notes) notes file. Learn more about the specification on https://otrn.editingtools.io",
        timestamp: OtrnMetadata.defaultTimestamp
    )

    // --- 6. Root Document ---
    let documentToWrite = OtrnDocument(
        metadata: metadata,
        sequence: sequence,
        files: [file] // Includes the file-specific notes
    )

    do {
        try documentToWrite.write(to: filePath)
        print("Successfully wrote OTRN document.")
    } catch {
        print("\nFATAL ERROR during Write: \(error)")
    }
}
